/*------------------------------------------------------------------------------*
 * File Name: User Friendly	Interface											*
 * Creation: GRD, 2002.06.29													*
 * Purpose: OriginC Source C file for Tutorial									*
 * Copyright (c) OriginLab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <origin.h>
////////////////////////////////////////////////////////////////////////////////////


// Set the Mouse Pointer to 'Busy' while long process continues
void BusyAsABee()
{
	// Create a Worksheet object from the active window
	Worksheet wks = Project.ActiveLayer();
	// If the active window is not a worksheet, create one from ORIGIN.OTW
	if(wks==NULL)
	{
		wks.Create("origin", CREATE_VISIBLE);
	}

	waitCursor	cur;		// Create a waitCursor object
	string		str;		// Create a string for messages
	int			nCol = 0;	// Create a variable to hold the number of columns added

	// Loop : 10000 times, but check for user pressing Escape key (v7SR1 or later)
	// for(int ii = 0; ii < 10000;ii++) // v7Release
	for(int ii = 0; ii < 10000 && !cur.CheckEsc();ii++)
	{
		// Add a column to the worksheet
		wks.AddCol();
		// Type a message to the Data Display window and increment column count
		str.Format("Adding col %d", nCol++);
		SetDataDisplayText(str);
	}
	// Check if the loop completed normally, otherwise the user must have pressed Escape key
	if(ii < 10000)
		printf("User aborted adding columns. %d columns were added.\n", nCol);
}


// Display a Progress Box
void Progress(int iBegin, int iEnd)
{
	int			iStep = 0;
	BOOL		bOK = 0;
	DWORD		dw1 = 0;
	DWORD		dw2 = 0;
	int			iDone = 0;
	int			iTemp;
	
	// Display the progress box
	progressBox pbox("Working...", 0);

	// Swap the arguments if the first is larger
	if(iBegin > iEnd)
	{
		iTemp = iBegin;
		iBegin = iEnd;
		iEnd = iTemp;
	}

	// Set the range
	pbox.SetRange(iBegin, iEnd);

	// Get the system tick count (in milliseconds)
	dw2 = GetTickCount();

	// Loop from the first number to the last
	for(iStep = iBegin; iStep <= iEnd; iStep++)
	{
		// Wait 1 second - This function is defined in this file
		WaitASec(1.0);
		// Set the progress indicator to the next value
		bOK = pbox.Set(iStep);
		// If the user pressed escape or clicked Cancel, then terminate the loop
		if(!bOK)
		{
			printf("Progress Box terminated by user.\n");
			return;
		}
	}
}


void RealTimeDisplay()
{
	Worksheet	wks;
	Dataset		dsX;
	Dataset		dsY;
	string		strWksName;
	string		strDSName1;
	string		strDSName2;
	GraphPage	graph;
	string		strGraphName;

	// Create a worksheet from the standard Origin worksheet template
	wks.Create("origin", CREATE_VISIBLE);
	// Get the worksheet name
	strWksName = wks.GetPage().GetName();
	// Attach to dataset and get column names
	dsX.Attach(strWksName,0);
	dsX.GetName(strDSName1);
	dsY.Attach(strWksName,1);
	dsY.GetName(strDSName2);

	// Create a graph from the Scatter graph template
	graph.Create("scatter",CREATE_VISIBLE);
	// and get its name
	Application.Pages().GetName(strGraphName);
	
	// Create a curve from the two dataset names
	Curve		cuvPlot(strDSName1, strDSName2);
	// and plot it
	graph.Layers(0).AddPlot(cuvPlot,IDM_PLOT_SCATTER);

	// Turn off Speed Mode, set scales, set point size and force graph to finish drawing
	LT_execute("layer.maxpts=0;x1=0;x2=10000;y1=0;y2=100;set %C -z 3;sec -p .1;");

	int			ii = 0;
	int			jj;
	int			iStartSize = 10;
	int			iLast;
	int			iNext;
	vector		vV1;
	vector		vV2;

	// Set dataset sizes to zero
	dsX.SetSize(0);
	dsY.SetSize(0);

	// Set vector sizes
	vV1.SetSize(iStartSize);
	vV2.SetSize(iStartSize);

//	progressBox	pbox("Updating plot in real time.",0);	// UNCOMMENT FOR PROGRESS BOX DISPLAY
//	pbox.SetRange(0,1000);								// UNCOMMENT FOR PROGRESS BOX DISPLAY
//	BOOL		bOK;									// UNCOMMENT FOR PROGRESS BOX DISPLAY
	
	// Repeat 1000 times
	for(jj = 1; jj <= 1000; jj++)
	{
//		bOK = pbox.Set(jj);								// UNCOMMENT FOR PROGRESS BOX DISPLAY
		iLast = ii;
		iNext = ii + iStartSize;
		// Fill the vectors with data
		for (; ii < iNext; ii++)
		{
			vV1[ii - iLast] = ii;
			vV2[ii - iLast] = rnd() * 100.0;
		}
		// Append the vectors to the datasets using realtime update
		dsX.Append(vV1,REDRAW_REALTIME);
		dsY.Append(vV2,REDRAW_REALTIME);
	}
	// Remove redraw message from the Windows queue
	// (We've been redrawing all along, so no need!)
	LT_execute("plot -v;");
}


// Delay a specified number of seconds
void WaitASec(double dSeconds)
{
	DWORD	dw1;
	DWORD	dw2;
	int		iDone;

	dw1 = GetTickCount();
	dw2 = dw1;
	for(iDone = 0; iDone==0; )
	{
		if((dw2 - dw1) < dSeconds * 1000.0) dw2 = GetTickCount(); else iDone = 1;
	}
}


